# バッチ設計書 6-Set audio decoding mode.ps1

## 概要

本ドキュメントは、StaxRipアプリケーションでFLACファイルとqaacエンコーダー使用時にオーディオデコードモードを自動設定するPowerShellスクリプト「Set audio decoding mode.ps1」の設計書です。

### 本バッチの処理概要

このスクリプトは、StaxRipのBeforeProcessingイベントに登録されるイベントハンドラで、オーディオファイルがFLAC形式でエンコーダーがqaacの場合にデコードモードを「Pipe」に自動設定します。

**業務上の目的・背景**：FLACファイルをqaacエンコーダーでエンコードする際、デコードモードによってはエンコード処理がうまくいかない場合があります。このスクリプトは、特定の条件（FLAC + qaac）が検出された場合に自動的にデコードモードを「Pipe」に設定することで、ユーザーが手動で設定する手間を省き、エンコード処理の成功率を向上させます。

**バッチの実行タイミング**：StaxRipのエンコード処理開始前（BeforeProcessingイベント発火時）に自動実行されます。スクリプトをStaxRipにロードすると、イベントハンドラとして登録され、以降のエンコード処理で自動的に呼び出されます。

**主要な処理内容**：
1. BeforeProcessingイベントへのイベントハンドラ登録
2. アクティブプロジェクトのAudio0およびAudio1トラックをチェック
3. オーディオプロファイルがGUIAudioProfile型で、ファイル拡張子が.flac、エンコーダーがqaacの場合を検出
4. 該当する場合にDecodingModeを「Pipe」に設定

**前後の処理との関連**：StaxRipのエンコード処理パイプラインの一部として機能します。BeforeProcessingイベントで設定が変更されると、後続のエンコード処理に反映されます。

**影響範囲**：プロジェクトのオーディオ設定（Audio0、Audio1のDecodingModeプロパティ）に影響します。条件に一致した場合のみ設定が変更されます。

## バッチ種別

イベントハンドラ / 自動設定

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | エンコード処理ごと |
| 実行時刻 | エンコード開始時 |
| 実行曜日 | 該当なし |
| 実行日 | 該当なし |
| トリガー | BeforeProcessingイベント |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| StaxRipの実行 | StaxRipアプリケーションが起動していること |
| スクリプトの登録 | スクリプトがStaxRipにロードされイベントハンドラが登録されていること |

### 実行可否判定

以下の条件がすべて満たされた場合にのみ設定が変更されます：
- オーディオプロファイルがGUIAudioProfile型である
- オーディオファイルの拡張子が.flacである
- エンコーダーがqaacである

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| なし | - | - | - | イベントから自動取得 |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| ShortcutModule.p | オブジェクト | アクティブプロジェクト情報 |
| activeProject.Audio0 | GUIAudioProfile | 第1オーディオトラック |
| activeProject.Audio1 | GUIAudioProfile | 第2オーディオトラック |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| Audio.DecodingMode | プロパティ | "Pipe"に設定 |

### 出力ファイル仕様

ファイル出力はありません。オブジェクトのプロパティを変更します。

## 処理フロー

### 処理シーケンス

```
1. イベントハンドラ登録
   └─ Register-ObjectEventでBeforeProcessingイベントに登録
2. イベント発火時の処理
   └─ アクティブプロジェクト取得
3. Audio0、Audio1のループ
   └─ 各オーディオトラックをチェック
4. 条件判定
   └─ GUIAudioProfile型 AND .flac拡張子 AND qaacエンコーダー
5. 設定変更
   └─ 条件一致の場合、DecodingModeを'Pipe'に設定
```

### フローチャート

```mermaid
flowchart TD
    A[スクリプトロード] --> B[イベントハンドラ登録]
    B --> C[BeforeProcessingイベント待機]
    C --> D[イベント発火]
    D --> E[アクティブプロジェクト取得]
    E --> F[Audio0チェック]
    F --> G{GUIAudioProfile?}
    G -->|No| H[Audio1チェック]
    G -->|Yes| I{.flac?}
    I -->|No| H
    I -->|Yes| J{qaac?}
    J -->|No| H
    J -->|Yes| K[DecodingMode=Pipe設定]
    K --> H
    H --> L{GUIAudioProfile?}
    L -->|No| M[処理完了]
    L -->|Yes| N{.flac?}
    N -->|No| M
    N -->|Yes| O{qaac?}
    O -->|No| M
    O -->|Yes| P[DecodingMode=Pipe設定]
    P --> M
```

## データベース操作仕様

### 操作別データベース影響一覧

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| なし | - | - | データベース操作なし |

### テーブル別操作詳細

データベース操作は行いません。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | スクリプトエラー | オーディオプロファイルがnullの場合 | 処理はスキップされる |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 該当なし（イベント駆動） |
| リトライ間隔 | 該当なし |
| リトライ対象エラー | 該当なし |

### 障害時対応

$ErrorActionPreference = 'Stop'が設定されているため、エラー発生時はスクリプトが停止します。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | 該当なし |
| コミットタイミング | 該当なし |
| ロールバック条件 | 該当なし |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 最大2トラック（Audio0、Audio1） |
| 目標処理時間 | 即時 |
| メモリ使用量上限 | 最小限 |

## 排他制御

排他制御は不要です。イベントハンドラはStaxRipのメインスレッドで実行されます。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| なし | - | ログ出力なし |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| なし | - | - |

## 備考

- Register-ObjectEventを使用してShortcutModule.gオブジェクトのBeforeProcessingイベントに登録します
- GetType().Nameで型名をチェックし、'GUIAudioProfile'と比較しています
- File.EndsWith('flac')で拡張子をチェックしています（大文字小文字区別なし）
- GetEncoder()メソッドでエンコーダー名を取得し、'qaac'と比較しています
- Audio0とAudio1の両方をチェックするため、ステレオやマルチオーディオプロジェクトにも対応します
- 条件に一致しない場合は何も変更されません
